-- V2D - 12549 Messaging for Leave Creation Event

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='Leave Management');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'LEAVE_APPROVER_APPROVE');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='LEAVE_APPROVER_APPROVE');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'EMPLOYEE_LEAVE_APPROVER_APPROVE', 'EMPLOYEE_LEAVE_APPROVER_APPROVE', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Employee Leave Approver Approve');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'LEAVE_APPROVER_APPROVE_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'LEAVE_APPROVER_APPROVE_RECIPIENT', 'SQL');

-- SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
-- INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BULK_DOCUMENT_DOWNLOAD_TDP', 'CB');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_APPROVER_APPROVE_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'LEAVE_APPROVER_APPROVE_RECIPIENT');


-- SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
-- SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='BULK_DOCUMENT_DOWNLOAD_TDP');
-- SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
-- INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) 
-- VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,NULL,NULL);


-- Link Template data provider to message category

-- SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='BULK_DOCUMENT_DOWNLOAD_TDP');
-- SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='LEAVE_APPROVER_APPROVE');
-- SET @templatedtproviderId=(SELECT MAX(id) FROM template_dtprovider);
-- INSERT INTO `template_dtprovider`(`id`,`msgSubCategoryId`,`dataProviderId`,`dataProviderName`) VALUES (@templatedtproviderId+1,@msgSubCategoryId,@dtproviderId,'BULK_DOCUMENT_DOWNLOAD_TDP');


-- The under sql code gives for the user distribution list ,this information can be fetched

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_APPROVER_APPROVE_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='LEAVE_APPROVER_APPROVE_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_APPROVER_APPROVE_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.id AS USER_ID   
FROM
    hr_emp_leave_request AS T1
        LEFT JOIN
    hr_emp_leave_request_detail AS T6 ON T6.empLeaveRequestId = T1.id
WHERE
    T1.id IN (namedParams) AND T6.status = 'pending' and T6.approverLevelId = (select MIN(approverLevelId) from hr_emp_leave_request_detail where empLeaveRequestId IN (namedParams) and status = 'pending')",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_APPROVER_APPROVE_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T1.id AS ID,
    aprover.emailId AS EMAIL_ID,
    aprover.mobileNumber AS MOBILE_NO,
    aprover.mobileCountryCode AS MOBILE_CODE,
    requester.printName AS REQUESTER_PRINT_NAME,
    requester.firstName AS REQUESTER_FIRST_NAME,
    requester.lastName AS REQUESTER_LAST_NAME,
    aprover.printName AS PRINT_NAME,
    aprover.firstName AS FIRST_NAME,
    aprover.lastName AS LAST_NAME,
    reqUser.code AS REQUESTER_CODE,
    T1.reason AS REASON,
    T5.salutationName AS SALUTATION_NAME,
    T8.eligibilityCriteria AS ELIGIBILITY_CRITERIA,
    T8.leaveCode As LEAVE_CODE,
	T8.leaveType As LEAVE_TYPE,
    T9.academyName AS ACADEMY_NAME,
	T9.locationName AS LOCATION_NAME,
	T9.displayName AS ACADEMY_NAME_LOCATION,
	T9.id AS ACADEMY_LOCATION_ID, 
    DATE_FORMAT(T1.fromDate, '%d-%m-%Y') AS FROM_DATE,
    DATE_FORMAT(T1.toDate, '%d-%m-%Y') AS TO_DATE
FROM
    hr_emp_leave_request AS T1
        LEFT JOIN
    hr_emp_leave_request_detail AS T6 ON T6.empLeaveRequestId = T1.id
        LEFT JOIN
    staffs AS T3 ON T3.userId = T1.requestUserId
        LEFT JOIN
    persons AS requester ON requester.id = T3.personId
       LEFT JOIN
    users AS reqUser ON reqUser.id = T3.userId
        LEFT JOIN
    staffs AS T7 ON T7.userId = T6.approverId
        LEFT JOIN
    persons AS aprover ON aprover.id = T7.personId
 		LEFT JOIN
    salutations AS T5 ON T5.id = aprover.salutationId
		LEFT JOIN
    hr_leave_type as T8 on T8.id  = T1.hrLeaveTypeId 
     LEFT JOIN
    academy_location T9 ON T9.id = T1.academyLocationId
WHERE
    T1.id IN (namedParams) AND T6.status = 'PENDING' and T6.approverLevelId = (select MIN(approverLevelId) from hr_emp_leave_request_detail where empLeaveRequestId IN (namedParams) and status = 'pending')",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },        
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "code",
            "resultKey": "REQUESTER_CODE",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "FROM_DATE",
            "resultKey": "FROM_DATE",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "TO_DATE",
            "resultKey": "TO_DATE",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "REQUESTER_FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 9,
            "value": "printName",
            "resultKey": "REQUESTER_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 8
        },        
        {
            "id": 10,
            "value": "lastName",
            "resultKey": "REQUESTER_LAST_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "reason",
            "resultKey": "REASON",
            "displayCode": "",
            "displayOrder": 10
        },
	 	{
            "id": 12,
            "value": "leaveCode",
            "resultKey": "LEAVE_CODE",
            "displayCode": "",
            "displayOrder": 11
        },
	 	{
            "id": 13,
            "value": "eligibilityCriteria",
            "resultKey": "ELIGIBILITY_CRITERIA",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "id",
            "resultKey": "ACADEMY_LOCATION_ID",
            "displayCode": "",
            "displayOrder": 16
        },
		{
            "id": 18,
            "value": "leaveType",
            "resultKey": "LEAVE_TYPE",
            "displayCode": "",
            "displayOrder": 17
        }
    ]
}');





-- Setting data in cb_dtprovider for the USER_UPDATE_LOGIN_CREDENTIAL_TDP ADDED

-- SET @cbdtproviderId=(SELECT MAX(id) FROM `cb_dtprovider`);
-- SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='BULK_DOCUMENT_DOWNLOAD_TDP');
-- insert  into `cb_dtprovider`(`id`,`dataProviderId`,`searchConfigCode`,`searchResultViewCode`) values (@cbdtproviderId+1, @dtproviderId,'BULK_DOCUMENT_DOWNLOAD_TDP','BULK_DOCUMENT_DOWNLOAD_TDP');




SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='EMPLOYEE_LEAVE_APPROVER_APPROVE');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='LEAVE_APPROVER_APPROVE');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='LEAVE_APPROVER_APPROVE_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Employee Leave Request Approval For Approver',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Employee Leave Request Approval For Approver',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Employee leave request has been forwarded for your approval','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Following leave request has been forwarded for your approval. To view more details, please login to
Employee Portal.</span></span></p>
            			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> <strong>Requester ID:</strong>&nbsp; $recipientData[&quot;REQUESTER_CODE&quot;]<br>
                        <strong>Requester Name:</strong>&nbsp; $recipientData[&quot;REQUESTER_FIRST_NAME&quot;] $recipientData[&quot;REQUESTER_LAST_NAME&quot;]<br>
                        <strong>Leave Type:</strong>&nbsp; $recipientData[&quot;LEAVE_TYPE&quot;]<br>
                        <strong>From:</strong>&nbsp; $recipientData[&quot;FROM_DATE&quot;]<br>
                        <strong>To:</strong>&nbsp; $recipientData[&quot;TO_DATE&quot;]<br>
                        <strong>Reason/Remark:</strong>&nbsp; $recipientData[&quot;REASON&quot;]<br>
                        </span></span></p>	
						<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards,<br /> <strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></span></span></p>	
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="http://www.serosoft.com/mailer/academiaerp-logo-red.png"/></td>
		</tr>
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Employee leave request has been forwarded for your approval','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Dear&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> Following leave request has been forwarded for your approval. To view more details, please login to
Employee Portal.</span></span></p>
            			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> <strong>Requester ID:</strong>&nbsp; $recipientData[&quot;REQUESTER_CODE&quot;]<br>
                        <strong>Requester Name:</strong>&nbsp; $recipientData[&quot;REQUESTER_FIRST_NAME&quot;] $recipientData[&quot;REQUESTER_LAST_NAME&quot;]<br>
                        <strong>Leave Type:</strong>&nbsp; $recipientData[&quot;LEAVE_TYPE&quot;]<br>
                        <strong>From:</strong>&nbsp; $recipientData[&quot;FROM_DATE&quot;]<br>
                        <strong>To:</strong>&nbsp; $recipientData[&quot;TO_DATE&quot;]<br>
                        <strong>Reason/Remark:</strong>&nbsp; $recipientData[&quot;REASON&quot;]<br>
                        </span></span></p>
						<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Kind regards,<br /> <strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></span></span></p>		
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="http://www.serosoft.com/mailer/academiaerp-logo-red.png"/></td>
		</tr>
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"], You have received an employee leave request for approval. Please login to Academia ERP and take necessary action');




-- End Messaging for EMPLOYEE_LEAVE_APPROVER_APPROVE Event
